<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Hashtag;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Hashtag\HashtagModel;

final class HashtagTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'hashtag';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    const ID = 'id';

    const DISPLAY_TEXT = 'display_text';

    const CACHE_POSTS_COUNT = 'cache_posts_count';

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID => 'id',

        self::DISPLAY_TEXT => 'displayText',

        self::CACHE_POSTS_COUNT => 'cachePostsCount',

        self::STAMP_REGISTRATION  => 'stampRegistration',
        self::STAMP_LAST_UPDATE   => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return '0';
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return HashtagModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }
}
